
if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi
seq_len=720
model_name=Timemodel

# Weather

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/weather/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path weather.csv \
  --model_id weather_$seq_len'_'96 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,144,144] \
  --dilation [1,2,5] \
  --pred_len 96 \
  --d_model 96 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16  >logs/LongForecasting/$model_name'_'Weather_$seq_len'_'96_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/weather/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path weather.csv \
  --model_id weather_$seq_len'_'192 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,144,144] \
  --dilation [1,2,5] \
  --pred_len 192 \
  --d_model 96 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16  >logs/LongForecasting/$model_name'_'Weather_$seq_len'_'192_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/weather/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path weather.csv \
  --model_id weather_$seq_len'_'336 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,144,144] \
  --dilation [1,2,5] \
  --pred_len 336 \
  --d_model 96 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16  >logs/LongForecasting/$model_name'_'Weather_$seq_len'_'336_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/weather/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path weather.csv \
  --model_id weather_$seq_len'_'720 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,144,144] \
  --dilation [1,2,5] \
  --pred_len 720 \
  --d_model 96 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16  >logs/LongForecasting/$model_name'_'Weather_$seq_len'_'720_s.log

# traffic
seq_len=720

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/traffic/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path traffic.csv \
  --model_id traffic_$seq_len'_'96 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,24,24] \
  --dilation [1,2,5] \
  --pred_len 96 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --c_out 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16 --learning_rate 0.05 >logs/LongForecasting/$model_name'_'traffic_$seq_len'_'96_s.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/traffic/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path traffic.csv \
  --model_id traffic_$seq_len'_'192 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,24,24] \
  --dilation [1,2,5] \
  --pred_len 192 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --c_out 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16 --learning_rate 0.05   >logs/LongForecasting/$model_name'_'traffic_$seq_len'_'192_s.log  

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/traffic/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path traffic.csv \
  --model_id traffic_$seq_len'_'336 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,24,24] \
  --dilation [1,2,5] \
  --pred_len 336 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --c_out 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16 --learning_rate 0.05   >logs/LongForecasting/$model_name'_'traffic_$seq_len'_'336_s.log  

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/traffic/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path traffic.csv \
  --model_id traffic_$seq_len'_'720 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,24,24] \
  --dilation [1,2,5] \
  --pred_len 720 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --c_out 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16 --learning_rate 0.05  >logs/LongForecasting/$model_name'_'traffic_$seq_len'_'720_s.log  

# # # # Electricity
seq_len=720
python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/electricity/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path electricity.csv \
  --model_id Electricity_$seq_len'_'96 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6,1] \
  --sconv_kernel [4,8,16,5,3] \
  --period [24,24,24,24,12] \
  --dilation [1,2,5] \
  --pred_len 96 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16  --learning_rate 0.001 >logs/LongForecasting/$model_name'_'electricity_$seq_len'_'96_s.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/electricity/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path electricity.csv \
  --model_id Electricity_$seq_len'_'192 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6,1] \
  --sconv_kernel [4,8,16,5,3] \
  --period [24,24,24,24,12] \
  --dilation [1,2,5] \
  --pred_len 192 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16  --learning_rate 0.001 >logs/LongForecasting/$model_name'_'electricity_$seq_len'_'192_s.log  

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/electricity/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path electricity.csv \
  --model_id Electricity_$seq_len'_'336 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6,1] \
  --sconv_kernel [4,8,16,5,3] \
  --period [24,24,24,24,12] \
  --dilation [1,2,5] \
  --pred_len 336 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16  --learning_rate 0.001  >logs/LongForecasting/$model_name'_'electricity_$seq_len'_'336_s.log  

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/electricity/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path electricity.csv \
  --model_id Electricity_$seq_len'_'720 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6,1] \
  --sconv_kernel [4,8,16,5,3] \
  --period [24,24,24,24,12] \
  --dilation [1,2,5] \
  --pred_len 720 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 16  --learning_rate 0.001  >logs/LongForecasting/$model_name'_'electricity_$seq_len'_'720_s.log  


# # # #Exchange_rate   # --conv_kernel [1,3,6,4] \# --period [24,24,24,168] \
seq_len=336

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/exchange_rate/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_$seq_len'_'96 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --dilation [1,1,1] \
  --pred_len 96 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 8 --learning_rate 0.0005 >logs/LongForecasting/$model_name'_'Exchange_$seq_len'_'96_s.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/exchange_rate/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_$seq_len'_'192 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --dilation [1,1,1] \
  --pred_len 192 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 8 --learning_rate 0.0005 >logs/LongForecasting/$model_name'_'Exchange_$seq_len'_'192_s.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/exchange_rate/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_$seq_len'_'336 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --dilation [1,1,1] \
  --pred_len 336 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 32  --learning_rate 0.0005 >logs/LongForecasting/$model_name'_'Exchange_$seq_len'_'336_s.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/exchange_rate/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_$seq_len'_'720 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --dilation [1,1,1] \
  --pred_len 720 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.0005 >logs/LongForecasting/$model_name'_'Exchange_$seq_len'_'720_s.log


# # #National_illness
seq_len=96

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/illness/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path national_illness.csv \
  --model_id national_illness_$seq_len'_'24 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4] \
  --period [24,24,48] \
  --dilation [1,1,1] \
  --label_len 18 \
  --pred_len 24 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.01 >logs/LongForecasting/$model_name'_'ili_$seq_len'_'24_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/illness/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path national_illness.csv \
  --model_id national_illness_$seq_len'_'36 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4] \
  --period [24,24,48] \
  --dilation [1,1,1] \
  --label_len 18 \
  --pred_len 36 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.01  >logs/LongForecasting/$model_name'_'ili_$seq_len'_'36_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/illness/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path national_illness.csv \
  --model_id national_illness_$seq_len'_'48 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4] \
  --period [24,24,48] \
  --dilation [1,1,1] \
  --label_len 18 \
  --pred_len 48 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.01  >logs/LongForecasting/$model_name'_'ili_$seq_len'_'48_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ../dataset/illness/ \
  --fa_path ../dataset/data_fa90/ \
  --data_path national_illness.csv \
  --model_id national_illness_$seq_len'_'60 \
  --model $model_name \
  --data custom \
  --features S \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4] \
  --period [24,24,48] \
  --dilation [1,1,1] \
  --label_len 18 \
  --pred_len 60 \
  --d_model 12 \
  --n_model 1 \
  --t_model 48 \
  --enc_in 1 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.01  >logs/LongForecasting/$model_name'_'ili_$seq_len'_'60_s.log
